<?php
include("connexion.php");

if (!isset($_GET['billet_id']) || !is_numeric($_GET['billet_id'])) {
    die("ID de billet invalide.");
}

$billet_id = intval($_GET['billet_id']);
$stmt = $db->prepare("SELECT * FROM billets WHERE id = :id");
$stmt->bindValue(':id', $billet_id, PDO::PARAM_INT);
$stmt->execute();
$billet = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$billet) {
    die("Billet non trouvé.");
}

$message = '';

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['modifier_billet'])) {
    $titre = $_POST['titre'];
    $contenu = $_POST['contenu'];

    $stmt = $db->prepare("UPDATE billets SET titre = :titre, contenu = :contenu WHERE id = :id");
    $stmt->bindValue(':titre', $titre, PDO::PARAM_STR);
    $stmt->bindValue(':contenu', $contenu, PDO::PARAM_STR);
    $stmt->bindValue(':id', $billet_id, PDO::PARAM_INT);
    $stmt->execute();

    $message = "Billet modifié avec succès.";
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Modifier Billet</title>
    <link href="CSS/mbillet.css" rel="stylesheet">
</head>
<body>
<header>
    <div class="logo"><a href="admin.php">ADMIN</a></div>
    <div class="nav-buttons">
        <a href="deco.php">Déconnexion</a>
    </div>
</header>

<?php if ($message) { ?>
    <div class="message"><?= htmlspecialchars($message) ?></div>
<?php } ?>

<h2>Modifier le Billet</h2>
<form action="modifbillet.php?billet_id=<?= $billet['id'] ?>" method="post">
    <label for="titre">Titre :</label>
    <input type="text" id="titre" name="titre" value="<?= htmlspecialchars($billet['titre'] ?? '') ?>" required><br>

    <label for="contenu">Contenu :</label>
    <textarea id="contenu" name="contenu" required><?= htmlspecialchars($billet['contenu'] ?? '') ?></textarea>

    <input type="submit" name="modifier_billet" value="Modifier">
</form>

<div class='back-button'>
    <button type='button' onclick='window.history.back();'>Retour</button>
</div>

</body>
</html>